﻿<?php
// ============================================================
// RELATÓRIO DE ESTATÍSTICAS DE ALUNOS - SISMAG (versão final otimizada)
// ============================================================

require('fpdf/fpdf.php'); // Biblioteca FPDF

// ----------------------
// Conexão com o Banco de Dados
// ----------------------
$host = "localhost";
$user = "root";
$pass = "";
$db = "sismag";
$port = 3306;

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// ----------------------
// Consultas SQL e Agrupamento de Dados (MANTIDAS)
// ----------------------
$sqlTotal = "SELECT COUNT(*) AS total_alunos FROM alunos a INNER JOIN matriculas m ON a.id = m.aluno_id";
$totalAlunos = ($conn->query($sqlTotal)->fetch_assoc()['total_alunos']) ?? 0;

$sqlGenero = "SELECT a.genero, COUNT(*) AS total FROM alunos a INNER JOIN matriculas m ON a.id = m.aluno_id GROUP BY a.genero";
$resGenero = $conn->query($sqlGenero);

$sqlIdadeGenero = "
    SELECT a.idade, a.genero, COUNT(*) AS total
    FROM alunos a
    INNER JOIN matriculas m ON a.id = m.aluno_id
    GROUP BY a.idade, a.genero
    ORDER BY a.idade ASC, a.genero ASC
";
$resIdadeGenero = $conn->query($sqlIdadeGenero);

$estatisticasPorIdade = [];
if ($resIdadeGenero) {
    while ($row = $resIdadeGenero->fetch_assoc()) {
        $idade = $row['idade'];
        if (!isset($estatisticasPorIdade[$idade])) {
            $estatisticasPorIdade[$idade] = ['total_idade' => 0, 'detalhes' => []];
        }
        $estatisticasPorIdade[$idade]['total_idade'] += $row['total'];
        $estatisticasPorIdade[$idade]['detalhes'][] = $row;
    }
}

$sqlTurmaIdadeGenero = "
    SELECT t.nome AS nome_turma, a.idade, a.genero, t.classe, t.curso, COUNT(*) AS total
    FROM alunos a
    INNER JOIN matriculas m ON a.id = m.aluno_id
    INNER JOIN turmas t ON m.turma_id = t.id
    GROUP BY t.nome, a.idade, a.genero, t.classe, t.curso
    ORDER BY t.classe, t.curso, t.nome, a.idade, a.genero
";
$resTurmaIdadeGenero = $conn->query($sqlTurmaIdadeGenero);

$estatisticasPorTurmaAgrupada = [];
if ($resTurmaIdadeGenero) {
    while ($row = $resTurmaIdadeGenero->fetch_assoc()) {
        $turma = "{$row['classe']} - {$row['curso']} - {$row['nome_turma']}";
        if (!isset($estatisticasPorTurmaAgrupada[$turma])) {
            $estatisticasPorTurmaAgrupada[$turma] = ['total_turma' => 0, 'idades' => []];
        }
        $idade = $row['idade'];
        if (!isset($estatisticasPorTurmaAgrupada[$turma]['idades'][$idade])) {
            $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade] = ['total_idade' => 0, 'generos' => []];
        }
        $estatisticasPorTurmaAgrupada[$turma]['total_turma'] += $row['total'];
        $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade]['total_idade'] += $row['total'];
        $estatisticasPorTurmaAgrupada[$turma]['idades'][$idade]['generos'][] = $row;
    }
}
$conn->close();

// ============================================================
// Classe extendida do FPDF com Cabeçalho e Rodapé personalizados
// ============================================================
class PDF_Estatisticas extends FPDF {
    function Header() {
        
        // --- Insígnia da República de Angola no topo e centralizada ---
        $largura_insignia = 25; // Largura da imagem em mm
        $x_centro = (210 / 2) - ($largura_insignia / 2); // 210mm é a largura A4
        
        if (file_exists('insignia/insignia.png')) {
            // Insígnia (x centralizado, y=8, largura=25)
            $this->Image('insignia/insignia.png', $x_centro, 8, $largura_insignia);
        }
        
        // Posiciona o cursor para o texto abaixo da insígnia (y=40mm é uma boa altura)
        $this->SetY(38);
        
        // --- Texto do Cabeçalho ---

        $this->SetFont('Arial', 'B', 11);
        $this->Cell(0, 6, utf8_decode('REPÚBLICA DE ANGOLA'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('GOVERNO PROVINCIAL DE BENGUELA'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('GABINETE PROVINCIAL DA EDUCAÇÃO'), 0, 1, 'C');
        $this->Cell(0, 6, utf8_decode('COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA'), 0, 1, 'C');
        $this->Ln(5);
        // Linha divisória
        $this->Line(10, $this->GetY(), 200, $this->GetY());
        $this->Ln(8);
    }

    function Footer() {
        // Rodapé de número de página
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, utf8_decode('Página ' . $this->PageNo()), 0, 0, 'C');
    }
}

// ============================================================
// Geração do PDF
// ============================================================
$pdf = new PDF_Estatisticas('P', 'mm', 'A4');
$pdf->SetTitle('Estatísticas de Alunos Matriculados', true);
$pdf->AddPage();

// ----------------------
// Título principal
// ----------------------
$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(0, 8, utf8_decode('ESTATÍSTICAS DE ALUNOS MATRICULADOS'), 0, 1, 'C');
$pdf->Ln(4);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 7, utf8_decode("Total de alunos matriculados: $totalAlunos"), 0, 1, 'L');
$pdf->Ln(6);

// ----------------------
// 1. Estatística por Género
// ----------------------
$pdf->SetFont('Arial', 'B', 13);
$pdf->Cell(0, 8, utf8_decode('1. Estatística por Género'), 0, 1, 'L');
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetFillColor(210, 230, 255);
$pdf->Cell(95, 7, utf8_decode('Género'), 1, 0, 'C', 1);
$pdf->Cell(95, 7, 'Total', 1, 1, 'C', 1);

$pdf->SetFont('Arial', '', 10);
if ($resGenero && $resGenero->num_rows > 0) {
    $resGenero->data_seek(0);
    while ($row = $resGenero->fetch_assoc()) {
        $pdf->Cell(95, 7, utf8_decode($row['genero']), 1, 0, 'C');
        $pdf->Cell(95, 7, $row['total'], 1, 1, 'C');
    }
} else {
    $pdf->Cell(190, 7, utf8_decode('Sem dados disponíveis.'), 1, 1, 'C');
}
$pdf->Ln(8);

// ----------------------
// 2. Estatísticas por Idade e Género (Com Rowspan)
// ----------------------
$pdf->SetFont('Arial', 'B', 13);
$pdf->Cell(0, 8, utf8_decode('2. Estatística por Idade e Género'), 0, 1, 'L');

$w_idade = [60, 70, 60];
$h_linha = 7;
$cor_total_idade = [200, 255, 200]; 
$cor_cabecalho = [220, 230, 255]; 

// Cabeçalho da Seção 2
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetFillColor($cor_cabecalho[0], $cor_cabecalho[1], $cor_cabecalho[2]);
$pdf->Cell($w_idade[0], $h_linha, utf8_decode('Idade'), 1, 0, 'C', 1);
$pdf->Cell($w_idade[1], $h_linha, utf8_decode('Género'), 1, 0, 'C', 1);
$pdf->Cell($w_idade[2], $h_linha, 'Total', 1, 1, 'C', 1);
$pdf->SetFont('Arial', '', 10);

foreach ($estatisticasPorIdade as $idade => $dados) {
    $detalhes = $dados['detalhes'];
    $rowspan = count($detalhes);
    $y_inicial = $pdf->GetY();
    $x_inicial = $pdf->GetX();

    foreach ($detalhes as $index => $linha) {
        // Coluna Idade (Simulação de Rowspan)
        if ($index == 0) {
            // Desenha a caixa e centraliza o texto da Idade
            $pdf->Rect($x_inicial, $y_inicial, $w_idade[0], $h_linha * $rowspan);
            $pdf->SetXY($x_inicial, $y_inicial + (($h_linha * $rowspan) / 2) - ($h_linha / 2));
            $pdf->Cell($w_idade[0], $h_linha, $idade, 0, 0, 'C');
            $pdf->SetXY($x_inicial + $w_idade[0], $y_inicial); // Volta para a posição
        }

        // Colunas Gênero e Total
        $pdf->SetX($x_inicial + $w_idade[0]);
        $pdf->Cell($w_idade[1], $h_linha, utf8_decode($linha['genero']), 1, 0, 'C');
        $pdf->Cell($w_idade[2], $h_linha, $linha['total'], 1, 1, 'C');
    }

    // Linha de Total da Idade
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetFillColor($cor_total_idade[0], $cor_total_idade[1], $cor_total_idade[2]);
    $pdf->Cell($w_idade[0] + $w_idade[1], $h_linha, utf8_decode("Total Idade $idade"), 1, 0, 'C', 1);
    $pdf->Cell($w_idade[2], $h_linha, $dados['total_idade'], 1, 1, 'C', 1);
    $pdf->SetFont('Arial', '', 10);
}
$pdf->Ln(10);

// ----------------------
// 3. Estatísticas por Turma (Contínuas, com Rowspan)
// ----------------------

// Função para desenhar o cabeçalho da tabela da turma
function drawTurmaHeader($pdf, $w, $h, $cor) {
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetFillColor($cor[0], $cor[1], $cor[2]);
    $pdf->Cell($w[0], $h, utf8_decode('Idade'), 1, 0, 'C', 1);
    $pdf->Cell($w[1], $h, utf8_decode('Género'), 1, 0, 'C', 1);
    $pdf->Cell($w[2], $h, 'Total', 1, 1, 'C', 1);
    $pdf->SetFont('Arial', '', 10);
}

// Verifica se há turmas para exibir esta seção
if (!empty($estatisticasPorTurmaAgrupada)) {
    
    $w_turma = [60, 70, 60];
    $h_turma_linha = 7;
    $cor_total_turma = [180, 255, 180];
    $cor_subtotal_idade = [240, 255, 240];
    
    // Alturas de referência
    $h_turma_header = 7;
    $h_turma_titulo = 9; // 8mm Cell + 1mm Ln
    $h_secao_titulo = 12; // 10mm Cell + 2mm Ln
    
    // Espaço mínimo para garantir que o título da seção não fique isolado (Título da Seção + Título da Turma + Cabeçalho da Tabela + 1 linha de dados)
    $espaco_minimo_necessario = $h_secao_titulo + $h_turma_titulo + $h_turma_header + $h_turma_linha + 5; 

    // **Ajuste para evitar orfandade do título da Seção 3**
    if ($pdf->GetY() + $espaco_minimo_necessario > $pdf->GetPageHeight() - 20) {
        $pdf->AddPage();
    }
    
    // Título da Seção 3
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(0, 10, utf8_decode('3. Estatísticas por Turma (Detalhe)'), 0, 1, 'L');
    $pdf->Ln(2);

    $primeira_turma = true;

    foreach ($estatisticasPorTurmaAgrupada as $turma => $dadosTurma) {
        
        // Pequeno espaçamento entre turmas (a partir da segunda)
        if (!$primeira_turma) {
            $pdf->Ln(5);
        }
        $primeira_turma = false;
        
        // Título da Turma
        $pdf->SetFont('Arial', 'BU', 11);
        $pdf->Cell(0, 8, utf8_decode("Turma: $turma"), 0, 1, 'L');
        $pdf->Ln(1);

        // Checa se cabe o cabeçalho + pelo menos 3 linhas de dados + total da turma.
        // Se precisar de quebra de página aqui, o título da turma já foi impresso,
        // mas o cabeçalho e os dados virão na próxima página.
        if ($pdf->GetY() + (3 * $h_turma_linha) + 20 > $pdf->GetPageHeight() - 20) {
            $pdf->AddPage();
            // Repete o título da turma como "Continuação" no topo da nova página
            $pdf->SetFont('Arial', 'BU', 11);
            $pdf->Cell(0, 8, utf8_decode("Turma: $turma (Cont.)"), 0, 1, 'L');
            $pdf->Ln(1);
        }
        
        // Desenha o cabeçalho da tabela da turma
        $cor_cabecalho = [220, 230, 255]; 
        drawTurmaHeader($pdf, $w_turma, $h_turma_linha, $cor_cabecalho);

        // Loop por Idade dentro da Turma
        foreach ($dadosTurma['idades'] as $idade => $dadosIdade) {
            
            $detalhes = $dadosIdade['generos'];
            $rowspan = count($detalhes);
            $y_inicial = $pdf->GetY();
            $x_inicial = $pdf->GetX();
            
            // Verifica quebra de página (cabe a idade + subtotal?)
            if ($pdf->GetY() + $h_turma_linha * $rowspan + $h_turma_linha + 5 > $pdf->GetPageHeight() - 20) {
                $pdf->AddPage();
                $pdf->SetFont('Arial', 'BU', 11);
                $pdf->Cell(0, 8, utf8_decode("Turma: $turma (Cont.)"), 0, 1, 'L');
                $pdf->Ln(1);
                // Redesenha o cabeçalho da tabela para a continuação da mesma turma
                drawTurmaHeader($pdf, $w_turma, $h_turma_linha, $cor_cabecalho);
                $y_inicial = $pdf->GetY();
                $x_inicial = $pdf->GetX();
            }

            // Loop por Gênero (Desenho das linhas)
            foreach ($detalhes as $index => $linha) {
                
                // Coluna Idade (Simulação de Rowspan)
                if ($index == 0) {
                    // Desenha a caixa e centraliza o texto da Idade
                    $pdf->Rect($x_inicial, $y_inicial, $w_turma[0], $h_turma_linha * $rowspan);
                    $pdf->SetXY($x_inicial, $y_inicial + (($h_turma_linha * $rowspan) / 2) - ($h_turma_linha / 2));
                    $pdf->Cell($w_turma[0], $h_turma_linha, $idade, 0, 0, 'C');
                    $pdf->SetXY($x_inicial + $w_turma[0], $y_inicial + $index * $h_turma_linha); // Volta para a posição da linha atual
                }
                
                // Colunas Gênero e Total
                $pdf->SetX($x_inicial + $w_turma[0]);
                $pdf->Cell($w_turma[1], $h_turma_linha, utf8_decode($linha['genero']), 1, 0, 'C');
                $pdf->Cell($w_turma[2], $h_turma_linha, $linha['total'], 1, 1, 'C');
            }

            // Linha de Subtotal por Idade
            $cor_subtotal_idade = [240, 255, 240];
            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetFillColor($cor_subtotal_idade[0], $cor_subtotal_idade[1], $cor_subtotal_idade[2]);
            $pdf->Cell($w_turma[0] + $w_turma[1], $h_turma_linha, utf8_decode("Total Idade $idade"), 1, 0, 'C', 1);
            $pdf->Cell($w_turma[2], $h_turma_linha, $dadosIdade['total_idade'], 1, 1, 'C', 1);
            $pdf->SetFont('Arial', '', 10);
        }
        
        // TOTAL GERAL DA TURMA
        $cor_total_turma = [180, 255, 180];
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetFillColor($cor_total_turma[0], $cor_total_turma[1], $cor_total_turma[2]);
        $pdf->Cell(array_sum($w_turma), 8, utf8_decode("TOTAL GERAL DA TURMA: {$dadosTurma['total_turma']}"), 1, 1, 'R', 1);
        $pdf->SetFont('Arial', '', 10);
    }
}


// ----------------------
// Rodapé ÚNICO (data e assinatura) - FICA NO FINAL
// ----------------------
// Garante espaço suficiente para o rodapé
if ($pdf->GetY() > $pdf->GetPageHeight() - 50) {
    $pdf->AddPage();
}

$meses = [
    '01'=>'Janeiro','02'=>'Fevereiro','03'=>'Março','04'=>'Abril','05'=>'Maio','06'=>'Junho',
    '07'=>'Julho','08'=>'Agosto','09'=>'Setembro','10'=>'Outubro','11'=>'Novembro','12'=>'Dezembro'
];
$dataHoje = 'Catumbela, ' . date('d') . ' de ' . $meses[date('m')] . ' de ' . date('Y');

$pdf->Ln(15);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 8, utf8_decode($dataHoje), 0, 1, 'R');
$pdf->Ln(15);

// Assinatura
$pdf->Cell(0, 8, utf8_decode('O DIRECTOR'), 0, 1, 'C');
$pdf->SetLineWidth(0.5);
$x1 = $pdf->GetPageWidth() / 2 - 40;
$y1 = $pdf->GetY() + 8;
$x2 = $x1 + 80;
$pdf->Line($x1, $y1, $x2, $y1); // Linha de assinatura
$pdf->Ln(15);
$pdf->Cell(0, 8, utf8_decode('EDUARDO SANJAMBELA TCHANDJA'), 0, 1, 'C');

// ----------------------
// Saída do PDF
// ----------------------
$pdf->Output('I', 'estatisticas_alunos.pdf');
?>